<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .main-container {
            max-width: 600px;
            margin: 50px auto;
        }
        .service-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            padding: 40px;
            backdrop-filter: blur(10px);
        }
        .service-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #667eea;
        }
        .service-header h2 {
            color: #667eea;
            font-weight: 700;
            font-size: 2rem;
            margin-bottom: 10px;
        }
        .service-header .badge {
            font-size: 1rem;
            padding: 8px 20px;
            border-radius: 20px;
        }
        .form-group {
            margin-bottom: 25px;
        }
        .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 10px;
            display: block;
            font-size: 1rem;
        }
        .form-control {
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            padding: 15px 20px;
            font-size: 1rem;
            transition: all 0.3s;
            background: #f8f9fa;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
            background: white;
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 15px 30px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 12px;
            width: 100%;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
            color: white;
        }
        .info-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 15px;
            margin-top: 20px;
            text-align: center;
        }
        .info-box i {
            font-size: 2rem;
            margin-bottom: 10px;
        }
        .text-muted {
            font-size: 0.9rem;
            color: #666;
            margin-top: 5px;
        }
        .balance-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            border-left: 4px solid #667eea;
        }
    </style>
</head>
<body>

<?php
include('../header.php');

/* ===================== FIXED PRICING ===================== */
$service_fee = 120; // Fixed ₹120 per search (All State Ration to Aadhar)
/* ========================================================= */

if (isset($_POST['find'])) {

    $ration_input  = mysqli_real_escape_string($ahk_conn, $_POST['ration_no']);
    $ration_number = preg_replace('/[^0-9A-Za-z]/', '', $ration_input);

    if (empty($ration_number)) {
        ?>
        <script>
        Swal.fire('Invalid Ration Number','Please enter valid Ration Number','error');
        </script>
        <?php
    } else {

        $appliedby     = $udata['phone'];
        $wallet_amount = floatval($udata['balance']);

        /* ===== WALLET CHECK ===== */
        if ($wallet_amount < $service_fee) {
            ?>
            <script>
            Swal.fire(
                'Insufficient Balance',
                'Required ₹<?php echo $service_fee; ?> | Balance ₹<?php echo number_format($wallet_amount,2); ?>',
                'error'
            );
            </script>
            <?php
        } else {

            /* ===== WALLET DEBIT ===== */
            $nbal = $wallet_amount - $service_fee;
            $debit = mysqli_query(
                $ahk_conn,
                "UPDATE users SET balance=balance-$service_fee WHERE phone='$appliedby'"
            );

            if (!$debit) {
                ?>
                <script>
                Swal.fire('Error','Wallet deduction failed','error');
                </script>
                <?php
            } else {

                mysqli_query($ahk_conn, "INSERT INTO wallethistory
                    (userid,amount,balance,purpose,status,type)
                    VALUES
                    ('$appliedby','$service_fee','$nbal',
                     'All State Ration to Aadhar - Ration No: $ration_number','1','Debit')");

                /* ===== API CALL ===== */
                $api_key = "api key enter"; // Your API Key
                $api_url = "https://lostdata.co.in/api/all-state-ration-to-aadhar.php";

                $url = $api_url . "?ration_no=" . urlencode($ration_number) . "&api_key=" . urlencode($api_key);

                $ch = curl_init();
                curl_setopt_array($ch, [
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_SSL_VERIFYPEER => false
                ]);

                $response   = curl_exec($ch);
                $curl_error = curl_error($ch);
                curl_close($ch);

                $result  = json_decode($response, true);
                $success = $result['success'] ?? false;
                $error   = $result['error'] ?? '';
                $message = $result['message'] ?? '';

                // New API Response Format
                $api_data = $result['data'] ?? [];
                $status = $api_data['status'] ?? ($result['status'] ?? '');
                $api_message = $api_data['message'] ?? '';
                $family_members = $api_data['members'] ?? ($result['members'] ?? []);

                $user_info = $result['user_info'] ?? [];
                $old_balance = $user_info['old_balance'] ?? '';
                $deducted = $user_info['deducted'] ?? '';
                $new_balance = $user_info['new_balance'] ?? '';

                /* ===== ERROR → REFUND ===== */
                if ($curl_error || !$success || $status !== 'success' || empty($family_members)) {

                    mysqli_query($ahk_conn,
                        "UPDATE users SET balance=balance+$service_fee WHERE phone='$appliedby'"
                    );

                    mysqli_query($ahk_conn, "INSERT INTO wallethistory
                        (userid,amount,balance,purpose,status,type)
                        VALUES
                        ('$appliedby','$service_fee','$wallet_amount',
                         'All State Ration to Aadhar Refund','1','Credit')");

                    $error_message = $message ?: ($error ?: "Ration number not found or data not available. Amount refunded.");
                    ?>
                    <script>
                    Swal.fire(
                        'Error',
                        '<?php echo addslashes($error_message); ?>',
                        'error'
                    );
                    setTimeout(()=>{window.location='all-state-ration-to-aadhar.php'},3000);
                    </script>
                    <?php
                } 
                /* ===== SUCCESS ===== */
                else {

                    date_default_timezone_set("Asia/Kolkata");
                    $time = date('d/m/Y g:i:s');

                    // Store COMPLETE API response (ALL DATA - NOTHING HIDDEN)
                    $complete_api_response = json_encode($result, JSON_UNESCAPED_UNICODE);

                    // Create history table if not exists
                    @mysqli_query($ahk_conn, "CREATE TABLE IF NOT EXISTS all_state_ration_to_aadhar_history (
                        id INT(11) AUTO_INCREMENT PRIMARY KEY,
                        username VARCHAR(100) NOT NULL,
                        ration_number VARCHAR(100) NOT NULL,
                        api_response TEXT,
                        members_count INT(11) DEFAULT 0,
                        service_charge DECIMAL(10,2) DEFAULT 0,
                        status VARCHAR(50) DEFAULT 'Success',
                        date DATETIME DEFAULT CURRENT_TIMESTAMP,
                        INDEX idx_username (username),
                        INDEX idx_ration (ration_number),
                        INDEX idx_date (date)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

                    mysqli_query($ahk_conn, "INSERT INTO all_state_ration_to_aadhar_history
                        (username,ration_number,api_response,members_count,service_charge,status,date)
                        VALUES
                        ('$appliedby','$ration_number','" . mysqli_real_escape_string($ahk_conn, $complete_api_response) . "',
                         '" . count($family_members) . "','$service_fee','Success','$time')");

                    // Build success message HTML - Show ALL API Details (NO HIDING)
                    $success_html = "<div style='text-align:left; max-height:600px; overflow-y:auto; font-family: Poppins, sans-serif;'>";
                    
                    // API Status Info Box
                    $success_html .= "<div style='background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; padding: 15px; border-radius: 10px; margin-bottom: 15px;'>";
                    $success_html .= "<strong><i class='fas fa-check-circle'></i> Status:</strong> " . htmlspecialchars($status) . "<br>";
                    $success_html .= "<strong><i class='fas fa-hashtag'></i> Ration Number:</strong> " . htmlspecialchars($ration_number) . "<br>";
                    $success_html .= "<strong><i class='fas fa-users'></i> Members Found:</strong> " . count($family_members) . "<br>";
                    $success_html .= "<strong><i class='fas fa-rupee-sign'></i> Service Charge:</strong> ₹" . number_format($service_fee, 2) . "<br>";
                    if (!empty($old_balance)) {
                        $success_html .= "<strong><i class='fas fa-wallet'></i> Old Balance:</strong> ₹" . number_format($old_balance, 2) . " | ";
                        $success_html .= "<strong><i class='fas fa-minus-circle'></i> Deducted:</strong> ₹" . number_format($deducted, 2) . " | ";
                        $success_html .= "<strong><i class='fas fa-check-circle'></i> New Balance:</strong> ₹" . number_format($new_balance, 2) . "<br>";
                    }
                    $success_html .= "</div>";
                    
                    // Show COMPLETE API Response (JSON) - ALL DETAILS VISIBLE
                    $success_html .= "<div style='background: #f8f9fa; padding: 15px; border-radius: 10px; margin-bottom: 15px; border-left: 4px solid #667eea;'>";
                    $success_html .= "<strong><i class='fas fa-code'></i> Complete API Response (ALL DATA):</strong><br>";
                    $success_html .= "<pre style='background: white; padding: 10px; border-radius: 5px; overflow-x: auto; font-size: 11px; margin-top: 10px; max-height: 250px; overflow-y: auto; white-space: pre-wrap; word-wrap: break-word;'>" . htmlspecialchars(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) . "</pre>";
                    $success_html .= "</div>";
                    
                    // Family Members Details Table
                    $success_html .= "<h5 style='color: #667eea; margin-bottom: 15px;'><i class='fas fa-users me-2'></i>Family Members Details:</h5>";
                    $success_html .= "<div style='overflow-x: auto;'>";
                    $success_html .= "<table style='width:100%; border-collapse:collapse; font-size:12px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; overflow: hidden;'>";
                    $success_html .= "<thead><tr style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;'>";
                    $success_html .= "<th style='padding: 12px; text-align: left;'>Sr</th>";
                    $success_html .= "<th style='padding: 12px; text-align: left;'>Name</th>";
                    $success_html .= "<th style='padding: 12px; text-align: left;'><strong>Aadhaar Number</strong></th>";
                    $success_html .= "</tr></thead><tbody>";
                    
                    foreach ($family_members as $index => $member) {
                        $bgColor = $index % 2 === 0 ? '#f8f9fa' : 'white';
                        $name = htmlspecialchars($member['name'] ?? 'N/A');
                        $aadhaar = htmlspecialchars($member['aadhaar'] ?? 'N/A');
                        
                        $success_html .= "<tr style='background: $bgColor;'>";
                        $success_html .= "<td style='padding: 12px; border-bottom: 1px solid #e0e0e0;'>" . ($index + 1) . "</td>";
                        $success_html .= "<td style='padding: 12px; border-bottom: 1px solid #e0e0e0; font-weight: 500;'>$name</td>";
                        $success_html .= "<td style='padding: 12px; border-bottom: 1px solid #e0e0e0;'><strong style='color: #667eea; font-size: 14px;'>$aadhaar</strong></td>";
                        $success_html .= "</tr>";
                    }
                    
                    $success_html .= "</tbody></table></div>";
                    
                    // Show Raw Data Section - COMPLETE DATA
                    $success_html .= "<div style='margin-top: 20px; background: #fff3cd; padding: 15px; border-radius: 10px; border-left: 4px solid #ffc107;'>";
                    $success_html .= "<strong><i class='fas fa-database'></i> Complete Raw Data (ALL FIELDS - NOTHING HIDDEN):</strong><br>";
                    $success_html .= "<pre style='background: white; padding: 10px; border-radius: 5px; overflow-x: auto; font-size: 11px; margin-top: 10px; max-height: 300px; overflow-y: auto; white-space: pre-wrap; word-wrap: break-word;'>" . htmlspecialchars(print_r($family_members, true)) . "</pre>";
                    $success_html .= "</div>";
                    
                    $success_html .= "</div>";

                    ?>
                    <script>
                    Swal.fire({
                        title: '<span style="color: #667eea;"><i class="fas fa-check-circle me-2"></i>All State Ration to Aadhar - Data Found Successfully</span>',
                        html: `<?php echo addslashes($success_html); ?>`,
                        icon: 'success',
                        width: 1100,
                        confirmButtonText: 'View History',
                        confirmButtonColor: '#667eea',
                        allowOutsideClick: false,
                        scrollbarPadding: false
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location = 'all-state-ration-to-aadhar-list.php';
                        }
                    });
                    setTimeout(()=>{
                        if (!Swal.isVisible()) {
                            window.location='all-state-ration-to-aadhar-list.php';
                        }
                    },60000); // 60 seconds timeout
                    </script>
                    <?php
                }
            }
        }
    }
}
?>

<!-- ===================== FORM ===================== -->

<div class="main-container">
    <div class="service-card">
        <div class="service-header">
            <h2><i class="fas fa-id-card me-2"></i>All State Ration to Aadhar</h2>
            <p class="text-muted mb-0">Find Aadhaar Numbers from Ration Card (All States)</p>
            <span class="badge bg-danger mt-2">₹<?php echo $service_fee; ?> per search</span>
        </div>

        <div class="balance-info">
            <strong><i class="fas fa-wallet me-2"></i>Your Balance:</strong> ₹<?php echo number_format($udata['balance'], 2); ?>
        </div>

        <form method="post">
            <div class="form-group">
                <label><i class="fas fa-hashtag me-2"></i>Ration Number</label>
                <input type="text" name="ration_no" class="form-control"
                       placeholder="Enter Ration Number" required autocomplete="off">
                <small class="text-muted">
                    <i class="fas fa-info-circle me-1"></i>Enter your Ration Card Number to find Aadhaar Numbers
                </small>
            </div>

            <div class="info-box">
                <i class="fas fa-shield-alt"></i>
                <p class="mb-0"><strong>Service Charge:</strong> ₹<?php echo $service_fee; ?></p>
                <small>Amount will be deducted from your wallet</small>
            </div>

            <button type="submit" name="find" class="btn btn-submit mt-3">
                <i class="fas fa-search me-2"></i>Find Aadhaar Numbers
            </button>
        </form>

        <div class="text-center mt-4">
            <a href="all-state-ration-to-aadhar-list.php" class="text-decoration-none">
                <i class="fas fa-history me-1"></i>View Search History
            </a>
        </div>
    </div>
</div>

<?php include('../footer.php'); ?>
</body>
</html>

